#version 450
#include <layout.glsl>

void main() {
    mat4 ipv = camera.ipv;
    float near = camera.near;
    float far = camera.far;

    gl_Position = sprites[gl_InstanceIndex].matrix * vec4(inputPosition, 1.0);
    outputColor = inputColor;
    outputUv = inputUv;
    outputRayOrigin = (ipv * vec4(gl_Position.xy, -1.0, 1.0) * near).xyz;
    float distance = far - near;
    outputRayDirection = (ipv * vec4(gl_Position.xy * distance, far + near, distance)).xyz;
}
